\name{corvec2mat}
\alias{corvec2mat}
\title{Convert from correlations in vector form to a correlation matrix}
\description{
Convert from correlations in vector form to a correlation matrix
}

\usage{
corvec2mat(rvec)
}
\arguments{
\item{rvec}{correlations in vector form of length d*(d-1)/2 in the order r12,r13,r23,r14,... r[d-1,d]}
}
\value{
 dxd correlation matrix}
\examples{
rvec = c(0.3,0.4,0.5,0.4,0.6,0.7)
Rmat = corvec2mat(rvec)
print(Rmat) # column 1 has 1, 0.3, 0.4, 0.4
# example from rposcorr_2mom which outputs one triangle of correlation matrix
a1 = 4.0; b1 = 8.0; d = 4
out2pos = rposcorr_2mom(3,d,a1,b1,123,1) 
colnames(out2pos) = c("r12","r13","r23","r14","r24","r34")
print(out2pos)
print(corvec2mat(out2pos[1,]))
print(corvec2mat(out2pos[2,]))
}
