\name{getbetapars_mp1}
\alias{getbetapars_mp1}
\title{With a[ell]=a1, recursion for second parameter b[ell] of Beta random variables  in (-1,1) for partial correlations in row/tree ell starting from  
 Beta(a1,b) distribution in (-1,1) for correlations in row 1 of C-vine, 
 so that all correlations have mean 2*a1/(a1+b)-1 
}
\description{
Get mu[ell] and b[ell], with a[ell]=a1, for Beta parameters of random 
partial correlations in row/tree ell=2,...,K,
starting from Beta(a1,b) in (-1,1) in row 1,
for the goal that all correlations have mean 2*a1/(a1+b)-1
}

\usage{
getbetapars_mp1(a1,b,K,iprint=FALSE)
}
\arguments{
\item{a1}{first parameter Beta(a1,b) on (-1,1) for correlation in tree/row 1}
\item{b}{second parameter Beta(a1,b) on (-1,1) for correlation in tree/row 1}
\item{K}{desired level: simulate random correlation matrices to dimension K}
\item{iprint}{TRUE for intermediate prints at tree levels}
}
\value{
 (muvec,bvec) as 2-column matrix: muvec is vector of mean parameters for random partial correlations in trees 2 to ell, ell<K if K is not feasible; 
bvec is vector of second Beta parameter if considering Beta(a1,bvec[ell]) 
for partial correlation in tree ell
}
\examples{
tem1 = getbetapars_mp1(a1=3,b=2,K=8,iprint=TRUE)
tem2 = getbetapars_mp1(a1=4,b=2,K=8,iprint=TRUE)
tem3 = getbetapars_mp1(a1=6,b=2,K=8,iprint=TRUE)
}
\references{
 Joe and Kurowicka (2026), Random correlation matrices generated via partial correlation C-vines.
Journal of Multivariate Analysis. https://doi.org/10.1016/j.jmva.2025.105519
}
