\name{rposcorr_2mom}
\alias{rposcorr_2mom}
\title{Generate random correlation matrices with all positive values based on C-vine with positive partial correlations, fixed mean and SD  
}
\description{
Generate random correlation matrices with all positive values based on
C-vine with positive partial correlations, with aim of a fixed mean
and a fixed SD for all correlations
}

\usage{
rposcorr_2mom(nsim,d,a1,b1,seed,ipermute=TRUE)
}
\arguments{
\item{nsim}{number of simulations}
\item{d}{dimension of correlation matrix, >=3}
\item{a1}{first parameter of Beta(a1,b1) random variable in (0,1) for row 1}
\item{b1}{second parameter of Beta(a1,b1) random variable in (0,1) for row 1; aim is for mean correlation value of mu=a1/(a1+b1) and variance mu*(1-mu)/(a1+b1+1)}
\item{seed}{positive integer seed for fortran90 code}
\item{ipermute}{permute flag, TRUE (default) for random row/column permutation }
}
\value{
 If input (d,a1,b1) is feasible, output  matrix nsim by d(d-1)/2,each row has a correlation matrix with lower triangle by row;
r12, r13, r23, r14, ..., r[d-1,d].
If input (d,a1,b1) is infeasible,  output is 0.
}
\details{
 Loop is done through link to Fortran90 code
}
\examples{
 # failed case
rposcorr_2mom(5,4,1.0,0.5,123)
# good case
a1 = 4.0; b1 = 8.0; d = 4
out2pos = rposcorr_2mom(1000,d,a1,b1,123,1) 
print(apply(out2pos,2,summary))
print(apply(out2pos,2,sd))
thmn = a1/(a1+b1)
thvar = thmn*(1-thmn)/(a1+b1+1)
cat("theoretical mean/s", thmn,sqrt(thvar),"\n")
colnames(out2pos) = c("r12","r13","r23","r14","r24","r34")
rcor = cor(out2pos)
print(round(rcor,3))
par(mfrow=c(3,3))
qqbeta(out2pos[,1],a1,b1,1,2)
qqbeta(out2pos[,2],a1,b1,1,3)
qqbeta(out2pos[,3],a1,b1,2,3)
qqbeta(out2pos[,4],a1,b1,1,4)
qqbeta(out2pos[,5],a1,b1,2,4)
qqbeta(out2pos[,6],a1,b1,3,4)
}
\references{
 Joe and Kurowicka (2026), Random correlation matrices generated via partial correlation C-vines. 
Journal of Multivariate Analysis. https://doi.org/10.1016/j.jmva.2025.105519
}
