\name{beta_mom2ab}
\alias{beta_mom2ab}
\title{Beta distributions : method of moments estimation }
\description{
Beta(a,b) on (0,1) or (-1,1): map from moments (mean, SD) to (a,b)
}

\usage{
beta_mom2ab(mu,s,imp1=FALSE)
}
\arguments{
\item{mu}{mean parameter, could be sample mean of data }
\item{s}{SD parameter, could be sample SD of data }
\item{imp1}{indicator of minus/plus1, TRUE if interval is (-1,1), FALSE if (0,1). Note that s^2<1-mu^2 for (-1,1) and s^2<mu*(1-mu) for (0,1)}
}
\value{
 list with (a,b,a+b) where a,b come from method of moments estimation
}
\examples{
beta_mom2ab(0.4,0.2,imp1=TRUE)
beta_mom2ab(0.4,0.2,imp1=FALSE)
}
