\name{qqbeta}
\alias{qqbeta}
\title{QQ plot for Beta(a,b) distribution on (0,1) or (-1,1)}
\description{
QQ plot for Beta(a,b) distribution on (0,1) or (-1,1)
}

\usage{
qqbeta(x,a,b,pos1=0,pos2=0)
}
\arguments{
\item{x}{data vector on (0,1) or (-1,1)}
\item{a}{alpha parameter>0}
\item{b}{beta parameter>0}
\item{pos1}{first subscript of correlation}
\item{pos2}{second subscript of correlation}
}
\value{
a QQ plot is produced, 0 is returned
}
\examples{
set.seed(1234)
n = 1000
x = rbeta(n,3,2)
mn = mean(x); s = sd(x)
ab = beta_mom2ab(mn,s)
qqbeta(x,ab[1],ab[2])
set.seed(12343)
n = 1000
x = 2*rbeta(n,5,3)-1
mn = mean(x); s = sd(x)
ab = beta_mom2ab(mn,s,imp1=TRUE)
qqbeta(x,ab[1],ab[2])
}
