\name{rcormat_mp1C}
\alias{rcormat_mp1C}
\title{Generate dxd correlation matrix with partial correlation C-vine.}
\description{
Random correlation matrix via partial correlation C-vine
}

\usage{
rcormat_mp1C(d, avec, bvec, ipermute=TRUE)
}
\arguments{
\item{d}{dimension >=3}
\item{avec}{vector of dimension d-1, first parameter of Beta(a_ell,b_ell) in (-1,1) by tree 1 to d-1}
\item{bvec}{vector of dimension d-1, second parameter Beta distribution in (-1,1) by tree 1 to d-1}
\item{ipermute}{permute flag, if TRUE random row/column permutation is applied}
}
\value{
 dxd positive correlation matrix, if TRUE row/column permutation is applied See rmp1corr_1mom and rmp1corr_2mom to generate many correlation matrices via Fortran90 
}
\examples{
# correlations in (-1,1) given mu
d = 4
mat = matrix(1:d^2,d,d)
iupper = upper.tri(mat)
a1 = 3; b1 = 2
mubobj = getbetapars_mp1(a1,b1,d-1,iprint=FALSE)
print(mubobj)
avec = rep(a1,d-1)
bvec = mubobj[,'bvec']  
nsim = 500
set.seed(1234)
out1_mp1 = matrix(0,nsim,d*(d-1)/2)
for(isim in 1:nsim)
{ rr = rcormat_mp1C(d,avec,bvec,ipermute=TRUE)
  out1_mp1[isim,] = rr[iupper]
}
print(rr)
colnames(out1_mp1) = c("r12","r13","r23","r14","r24","r34")
print(summary(out1_mp1))
print(apply(out1_mp1,2,sd))
# mp1 given 2 moments
a1 = 8; b1 = 5
mubobj = get2betapars_mp1(a1,b1,d-1,iprint=FALSE)
print(mubobj)
avec = mubobj[,'a']
bvec = mubobj[,'b']
nsim = 500
set.seed(1234)
out2_mp1 = matrix(0,nsim,d*(d-1)/2)
for(isim in 1:nsim)
{ rr = rcormat_mp1C(d,avec,bvec,ipermute=TRUE)
  out2_mp1[isim,] = rr[iupper]
}
colnames(out2_mp1) = c("r12","r13","r23","r14","r24","r34")
print(summary(out2_mp1))
print(apply(out2_mp1,2,sd))
}
