\name{rposcorr_1mom}
\alias{rposcorr_1mom}
\title{Generate random correlation matrices with all positive values based on C-vine with positive partial correlations, fixed mean 
}
\description{
Generate random correlation matrices with all positive values based on
C-vine with positive partial correlations, with aim of a fixed mean
for all correlations  
}

\usage{
rposcorr_1mom(nsim,d,a1,b,seed,ipermute=TRUE)
}
\arguments{
\item{nsim}{number of simulations}
\item{d}{dimension of correlation matrix, >=3}
\item{a1}{first parameter of Beta(a1,b) random variable in (0,1) for row 1}
\item{b}{second parameter of Beta(a1,b) random variable in (0,1) for row 1; aim is for mean correlation value of a1/(a1+b)}
\item{seed}{positive integer seed for fortran90 code}
\item{ipermute}{permute flag, TRUE (default) for random row/column permutation }
}
\value{
 If input (d,a1,b) is feasible, output  matrix nsim by d(d-1)/2,each row has a correlation matrix with lower triangle by row;
r12, r13, r23, r14, ..., r[d-1,d].
If input (d,a1,b) is infeasible,  output is 0.
}
\details{
 Loop is done through link to Fortran90 code
}
\examples{
 # failed case
rposcorr_1mom(5,4,1.0,0.3,123)
# good case
a1 = 1.5; b = 0.5; d = 6
out1pos = rposcorr_1mom(1000,d,a1,b,123,1) 
print(apply(out1pos,2,summary))
print(apply(out1pos,2,sd))
mubobj = getbetapars_pos(a1,b,d-1,iprint=FALSE)
print(mubobj)
avec = rep(a1,d-1)
bvec = mubobj[,'bvec']
recur = recursion_pos(rep(a1,d-1),mubobj[,'bvec'])
print(recur)
s = recur[d-1,7]  # theoretical SD after permutation
mn = recur[d-1,6] 
cat("theoretical mean/s", mn,s,"\n")
}
\references{
 Joe and Kurowicka (2026), Random correlation matrices generated via partial correlation C-vines.
Journal of Multivariate Analysis. https://doi.org/10.1016/j.jmva.2025.105519
}
