! functions for random correlation matices
!
!program mainsim1
!  implicit none
!  integer d,seed,dd,ipos,ipermute,nsim,isim
!  double precision , dimension(:,:), allocatable :: rvec
!  double precision , dimension(:), allocatable :: avec,bvec
!  nsim=5
!  ! extend to read nsim, ipos, ipermute, avec,bvec? 
!  d=4
!  dd=d*(d-1)/2
!  allocate(avec(d),bvec(d),rvec(nsim,dd))
!  seed=123
!  ipos=1
!  ipermute=0
!  avec=1.d0
!  bvec=3.d0
!  bvec(2)=3.765251d0; bvec(3)=4.569466d0
!  print *, d,seed,ipos,ipermute
!  print '(10f8.4)', avec
!  print '(10f8.4)', bvec
!  print *, " "
!  call simmethod1(nsim, d, avec, bvec, ipos, seed, ipermute, dd, rvec)
!  do isim=1,nsim
!    print '(10f8.4)', rvec(isim,:)
!  end do
!  deallocate(avec,bvec,rvec)
!  return
!  end

! C-vine partial correlation matrix to correlation matrix
subroutine pcor2cor_cvine(pc,rr,d)
  implicit none
  integer d
  double precision pc(d,d), rr(d,d), tem
  integer i,j,k,m
  rr=0.d0
  do i=1,d
    rr(i,i)=1.d0
  end do
  do j=2,d
    rr(1,j)=pc(1,j)
    rr(j,1)=pc(1,j)
  end do
  do j=2,(d-1)
    do k=(j+1),d
      tem=pc(j,k)
      do m=(j-1),1,-1
        tem=pc(m,j)*pc(m,k)+tem*sqrt((1.d0-pc(m,j)**2)*(1.d0-pc(m,k)**2)) 
      end do
      rr(j,k)=tem; rr(k,j)=rr(j,k)
    end do
  end do
  return
  end



! 1. Start with a d-dimensional partial correlation C-vine.
! 2. Let a_1,...,a_{d-1} be positive parameters for trees 1 to d-1.
! 3. For tree 1, generate independent correlations from a distribution with parameter a_1.
! 4. For tree ell (2<=ell<=d-1), generate independent partial correlations from a distribution with parameter a_ell.
! 5. Convert to partial correlations to a dxd correlation matrix R0
! 6. Permute the indices 1:d to get perm=(i_1,...,i_d)
! 7. Return R = R0[perm,perm] with permuted rows/columns.
!   R is always positive definite.

subroutine simmethod1(nsim, d, avec, bvec, ipos, seed, ipermute, dd, rvec)
  implicit none
  integer nsim,d,seed,ipos,ipermute,dd
  integer j,ell,i,isim,jj
  integer , dimension(:), allocatable :: perm
  double precision a,b,mult,add
  double precision avec(d),bvec(d),rvec(nsim,dd) 
  double precision rbeta,rpc,tem
  double precision , dimension(:,:), allocatable :: pcmat,r,rperm
  ! d>=3
  allocate (pcmat(d,d),r(d,d),rperm(d,d), perm(d))
  if(ipos==1) then
    mult=1.d0; add=0.d0
  else
    mult=2.d0; add= -1.d0
  end if
  dd=d*(d-1)/2
  call srand(seed)
  rvec = 0.d0
  do isim=1,nsim
    r = 0.d0
    pcmat = 0.d0
    do ell=1,(d-1)
      b = bvec(ell)
      a = avec(ell)
      do j=(ell+1),d
        rpc = rbeta(a,b)*mult + add
        pcmat(ell,j) = rpc 
      end do
    end do
    call pcor2cor_cvine(pcmat,r,d)
    if(ipermute==1) then 
      call isample(d,d,perm)
      do i=1,d
        do j=1,d 
          rperm(i,j) = r(perm(i),perm(j))
        end do
      end do
    else
      do i=1,d
        do j=1,d 
          rperm(i,j) = r(i,j)
        end do
      end do
    end if
    ! save lower triangular matrix by row for ok or not
    jj=0
    do i=2,d
      do j=1,(i-1)
        jj=jj+1
        rvec(isim,jj)=rperm(i,j)  
      end do
    end do 
  end do
  deallocate (pcmat,r,rperm,perm)
  return
  end

