function y = GenerateCorMatrixOnionEta(d,eta)
% Generates a correlation matrix of size d x d with the Onion method
% eta=1 for uniform, eta>0 for density proportional to [det(R)]^{eta-1}
%  marginal density of each r[i,j] is Beta(eta+(d-2)/2, eta+(d-2)/2)
  y = eye(d,d); % initialize
  % k = 2
  b = sqrt(betarnd(1/2,eta+(d-2)/2,1,1));
  u = 2*unidrnd(2,1,1)-3;
  q = b*u;
  y(1,2) = q;
  y(2,1) = q;
      
  % k > 2
  for k = 3:d
    % c = chol(y(1:k-1,1:k-1),'lower');
    % for Octave, which returns upper
    c = chol(y(1:k-1,1:k-1));
    b = sqrt(betarnd((k-1)/2,eta+(d-k)/2,1,1));
    u = GenerateSphereUnif(k-1);
    q = c'*b*u;
    y(1:k-1,k) = q;
    y(k,1:k-1) = q';
  end
end

function y = GenerateSphereUnif(n)
% Generates 1 sample of n-dimensional uniform distribution on a sphere
  N = normrnd(0,1,n,1);
  y = N./sqrt(sum(N.^2));
end
