function y = GenerateCorMatrixVine(d)
% Generates a correlation matrix of size d x d with the C-vine method
  y = eye(d); % Initialization speeds up calculations
  % row = 1
  alp = 1+(d-2)/2;
  y(1,2:d) = 2*betarnd(alp,alp,1,d-1)-1;
  prr(1,:) = y(1,:);

  % row > 1
  for m = 2:d-1
    alp = 1+(d-1-m)/2;
    prr(m,m+1:d) = 2*betarnd(alp,alp,1,d-m)-1;
    for i = m+1:d
      tem = prr(m,i);
      for k = m-1:-1:1
        tem = prr(k,m)*prr(k,i) + ...
          tem*sqrt((1-prr(k,m)*prr(k,m))*(1-prr(k,i)*prr(k,i))); 
      end
      y(m,i) = tem;
    end
  end
  y = y + y' - eye(d);
end
