
% simulation from Onion method with eta parameter (eta>0)
function [s1 s2] = simonionEta(d,nsim,eta)
  s1=eye(d,1);
  s2=eye(d,1);
  %eta=1;
  %d=3;
  for i = 1:(d-1)
    s1(i)=0;
    s2(i)=0;
  end

  for isim=1:nsim
    a=GenerateCorMatrixOnionEta(d,eta);
    for i = 1:(d-1)
      tem=a(i,i+1);
      s1(i)=s1(i)+tem;
      s2(i)=s2(i)+tem*tem;
    end
  end

  % This is used to check correctness, 
  % should get mean of 0 and variance of 1/(2*eta+d-1)
  for i = 1:(d-1)
    s1(i)=s1(i)/nsim;
    s2(i)=s2(i)/nsim;
    s2(i)=s2(i)-s1(i)*s1(i);
  end

  %s1';
  %s2';
  % theoretical var 
  thvar=1/(2*eta+d-1);
  s1(d)=0;
  s2(d)=thvar;
end
