knitr::opts_chunk$set(echo = TRUE)
dp = 5

x1 = read.table(paste(getwd(), "/data/x100.txt", sep = ""), header = F)
colnames(x1) = paste('x', c(1:dp), sep = '')
y1 = read.table(paste(getwd(), "/data/logy100.txt", sep = ""), header = F)[,  2]

x2 = read.table(paste(getwd(), "/data/x150.txt", sep = ""),header = F)
colnames(x2) = paste('x', c(1:dp), sep = '')
y2 = read.table(paste(getwd(), "/data/logy150.txt", sep = ""), header = F)[, 2]
set.seed(100 + 69)
tst = sample(1:150, 100, replace = F)
xf = x2[tst, ]
rownames(xf) = c(1:100)
yf = data.frame(y = y2[tst]) 
rownames(yf) = c(1:100)
xp = rbind(x1, x2[-tst, ])
rownames(xp) = c(1:150)
yp = data.frame(y = c(y1, y2[-tst]))

source(paste(getwd(),"/Hybrid_PowExp/hybrid_powexp.R", sep = ""))
########smoothness parameters
alpha = c(1.0086779, 2, 1.7810691, 1.9886917, 1.8338945)
########Fit the model
fit_h<-runBMCMC(nmcmc = 10000, burn = 4000, thin = 10, x = xf, y = yf, xtest1 = xp, 
                lambda.ini = rep(0.5, dp), lambda.w.ini = rep(0.1, dp), alpha)
print(sqrt(sum((fit_h$pred.y - yp$y)^2) / length(yp$y)))
print(sqrt(sum((fit_h$pred.y-yp$y)^2) / length(yp$y)) / sqrt(sum((mean(yf$y)-yp$y)^2) / length(yp$y)))

source(paste(getwd(),"/Full_PowExp/full_powexp.R", sep = ""))
########Fit the model
fit_f<-runBMCMC(nmcmc = 10000, burn = 4000, thin = 10, x = xf, y = yf, xtest1 = xp, 
                lambda.ini = rep(0.5, dp), lambda.w.ini = rep(0.1, dp), gamma.ini = rep(5, dp), 
                gamma.w.ini = rep(20, dp))
print(sqrt(sum((fit_f$pred.y-yp$y)^2)/length(yp$y)))
print(sqrt(sum((fit_f$pred.y - yp$y)^2) / length(yp$y)) / sqrt(sum((mean(yf$y) - yp$y)^2) / length(yp$y)))

source(paste(getwd(), "/Hybrid_Matern/hybrid_matern.R", sep = ""))
########smoothness parameters
cp = c(0, 2, 1, 1, 1)
########Fit the model
fit_m<-runBMCMC(nmcmc = 10000, burn = 4000, thin = 10, x = xf, y = yf, xtest1 = xp, 
               lambda.ini = rep(0.5, dp), lambda.w.ini = rep(0.1, dp), cp)
print(sqrt(sum((fit_m$pred.y-yp$y)^2) / length(yp$y)))
print(sqrt(sum((fit_m$pred.y - yp$y)^2) / length(yp$y)) / sqrt(sum((mean(yf$y) - yp$y)^2) / length(yp$y)))
