########### Bayesian Hybrid with Matern structure
########### functions 
###(1) dist.R() # compute the distances. 
###(2) log.posterior() 
###(3) repmat()
###(4) cov.r1.dis()
###(5) cov.r1()
###(6) s.square1()
###(7) pred1()
###(8) bceMCMC()
###(9) runBMCMC()
###############
## Coded by Hao Chen supervised by Dr. Will Welch 
## Last change was made on Jan 30, 2017.  
##############
dist.R<-function(x){
n<-nrow(x)
d<-mat.or.vec(n,n)
inds=n*(n-1)/2
indi=mat.or.vec(inds,1)
indj=mat.or.vec(inds,1)
ind=1
for (ii in 2:n-1) 
{
  indi[ind:(ind+n-ii-1)]=ii 
  indj[ind:(ind+n-ii-1)]=(ii+1):n
  ind=ind+n-ii 
}
tem.dup<-abs(x[indi,]-x[indj,])
odut=indi + n*(indj-1)
ttm<-list(d=d,odut=odut, dup=tem.dup)
return(ttm)
}


###(1)
log.post1<-function(d, odut,dup, y, lambda, cp){
##rho must be a  vector
#####distance matrix & R  
y=y; 
rho=exp(-lambda)/(1+exp(-lambda))
phi=-4*log(rho); 
#phi=-4*log(rho)
d<-d; odut<-odut; dup<-dup
n<-dim(d)[1]
ddp<-length(cp)
dis<-rep(1, dim(dup)[1])
for(j in 1:ddp){
h <- phi[j]*dup[,j] 
tem<-cp[j]
if(tem==0){
dis <- dis * exp(-h)
}

if(tem==1){
  dis <- dis *exp(-h)*(h+1)
}

if(tem==2){
  dis <- dis *exp(-h) * ((h^2/3)+h+1)  
}

if(tem>=3){
  dis <- dis * exp(-phi[j]*(dup[,j])^2) 
}
}
dis.m<-as.matrix(dis)
d[odut]<-dis.m
d<-d+t(d)
diags = seq(0,n*(n-1),by=n) + 1:n
d[diags] = 1
R<-d
U<-try(chol(R),silent=T)
if (class(U)=="try-error")
{ 
  logpost=-9e99; mu.hat=logpost; sigma.hat=logpost
}
else{
F1=mat.or.vec(n,1)+1
k=1
S=backsolve(U,F1,transpose=T)
S1=crossprod(S)
G=backsolve(U,y,transpose=T)
A=crossprod(S,G)
##mu.hat
mu.hat=solve(S1,A)
B=y-mu.hat*F1
B1=backsolve(U,B,transpose=T)
B2=crossprod(B1)
sigma.hat=(1/(n-k))*B2
logdet = sum(log(diag(U)))
S2=log(det(crossprod(S)))
tem1=0.5*(exp(-lambda)/(1+exp(-lambda)))^(-0.5)*(1+exp(-lambda))^(-2)*exp(-lambda)
tem11<-sum(log(tem1))
logprior<-tem11
logpost=logprior-(0+(n-k)/2)*log(0+(n-k)*sigma.hat/2)-0.5*S2-logdet
}
para=list(logpost=logpost,R=R,mu=mu.hat,sigma=sigma.hat)
return(para)
}



###pre-for dis2
repmat = function(X,m,n){
##R equivalent of repmat (matlab)
mx = dim(X)[1]
nx = dim(X)[2]
matrix(t(matrix(X,mx,nx*n)),mx*m,nx*n,byrow=T)
}


cov.r1.dis<-function(x,xtest1){
n<-dim(x)[1]
m<-dim(xtest1)[1]
inds=n*m
indi=repmat(matrix(c(1:n),ncol=n),1,m)
indj=repmat(matrix(c(1:m),ncol=m),n,1)
indj=t(unlist(list(indj)))
dis.tem<-abs(x[indi,]-xtest1[indj,])
return(list(dis=dis.tem))
}

####r^prime
cov.r1<-function(dis,lambda, n, m, cp){
rho=exp(-lambda)/(1+exp(-lambda))
phi=-4*log(rho); 
dis<-dis
dis.t<-rep(1, dim(dis)[1])
ddp<-length(cp)
for(j in 1:ddp){
tem<-cp[j]
h <- phi[j]*dis[,j]

if(tem==0){
dis.t <- dis.t * exp(-h)
}
  
if(tem==1){
  dis.t <- dis.t *exp(-h) * (h+1)
}
  
if(tem==2){
  dis.t <- dis.t * exp(-h)*(((h)^2/3)+h+1)  
}
  
if(tem>=3){
  dis.t <- dis.t * exp(-phi[j]*(dis[,j])^2) 
}
}
r<-dis.t
r.matrix<-matrix(r,nrow=m,ncol=n,byrow=T)
return(r.matrix)
}

s.square1<-function(sigma,r,R){
sigma<-sigma;R<-R;r=r
n=dim(R)[1]
one<-as.matrix(rep(1,n),ncol=1)
U<-chol(R)
r.t<-t(r)
Rinf=backsolve(U,r.t,transpose=T)
fRinf=crossprod(Rinf)
tem1<-1-as.numeric(diag(fRinf))
rm(fRinf)
w<-backsolve(U,one,transpose=T)
FRr<-crossprod(w,Rinf)
FRF<-crossprod(w)
tem2<-(1-FRr)^2/as.numeric(FRF)
results<-(tem1+tem2)*((n-1)*sigma+0)/(n-1+0)
rett<-matrix(results,ncol=1,byrow=F)
return(rett)
}


###(4) prediction
pred1<-function(d,odut,dup,dis,y,lambda, cp){  
rho=exp(-lambda)/(1+exp(-lambda))
phi=-4*log(rho)
n<-dim(d)[1]
m<-dim(dis)[1]/n
one<-as.matrix(rep(1,n))
y.vector<-as.matrix(y)
res<-matrix(nrow=1,ncol=m)
v.term2<-matrix(nrow=1,ncol=m)
gpost<-log.post1(d, odut,dup, y, lambda, cp)
mu.hat<-as.numeric(gpost$mu)
sigma.hat<-as.numeric(gpost$sigma)
hat.R<-gpost$R
rm(gpost)
U<-chol(hat.R)
r.matrix<-cov.r1(dis, lambda, n, m, cp)
r.t<-t(r.matrix)
cRr<-backsolve(U,r.t,transpose=T)
cRyb<-backsolve(U,(y.vector-one*mu.hat), transpose=T)
res<-t(matrix(rep(mu.hat,m),ncol=1)+crossprod(cRr,cRyb))
v.term2<-t(s.square1(sigma.hat,r.matrix,hat.R))
dd<-list(res=res, v.term2=v.term2)
return(dd)
}

#####(2)MCMC
bceMCMC<-function(nmcmc,burn,thin,x,y,xtest1, lambda.ini, lambda.w.ini, cp){
nmcmc=nmcmc
burn=burn
thin=thin
x=x
xtest1=xtest1
y=y
dp<-ncol(x)
j=0
mcmc.ma.lambda<-NULL
mcmc.ma.lambda<-matrix(nrow=nmcmc,ncol=dp,byrow=T)
accept.lambda<-NULL
accept.lambda<-matrix(c(rep(0,dp)),nrow=1,ncol=dp,byrow=T)
reasonable.lambda<-NULL
reasonable.lambda<-matrix(c(rep(0,dp)),nrow=1,ncol=dp,byrow=T)
lambda<-lambda.ini
lambda.w.ini<-lambda.w.ini
res<-matrix(nrow=(nmcmc-burn)/thin,ncol=nrow(xtest1))
v.term2<-matrix(nrow=(nmcmc-burn)/thin,ncol=nrow(xtest1))
ff<-dist.R(x)
cov.dd<-cov.r1.dis(x,xtest1)
for(i in 1:1){
for(k in 1:dp){
lambda.cond<-NULL
lambda.cond<-lambda  
temlambda<-0.95*rnorm(1, mean=lambda[k], sd=2.38*lambda.w.ini[k])+
  0.05*rnorm(1, mean=lambda[k], sd=0.1)
  lambda.cond[k]<-temlambda
  com.phi<-log.post1(d=ff$d, odut=ff$odut,dup=ff$dup, y,lambda.cond, cp)$logpost-
    log.post1(d=ff$d, odut=ff$odut,dup=ff$dup,y,lambda, cp)$logpost
  u<-runif(1)
  if(log(u)<com.phi){
    lambda[k]<-lambda.cond[k]
    accept.lambda[1,k]=accept.lambda[1,k]+1
  }
  reasonable.lambda[1, k]=reasonable.lambda[1,k]+1
}
mcmc.ma.lambda[i,]<-lambda
}

for(i in 2:2){
for(k in 1:dp){
lambda.cond<-NULL
lambda.cond<-lambda  
temlambda<-0.95*rnorm(1, mean=lambda[k], sd=2.38*lambda.w.ini[k])+
0.05*rnorm(1, mean=lambda[k], sd=0.1)
lambda.cond[k]<-temlambda
com.phi<-log.post1(d=ff$d, odut=ff$odut,dup=ff$dup, y,lambda.cond, cp)$logpost-
log.post1(d=ff$d, odut=ff$odut,dup=ff$dup,y,lambda, cp)$logpost
u<-runif(1)
if(log(u)<com.phi){
lambda[k]<-lambda.cond[k]
accept.lambda[1,k]=accept.lambda[1,k]+1
}
reasonable.lambda[1, k]=reasonable.lambda[1,k]+1
}
mcmc.ma.lambda[i,]<-lambda
}

for(i in 3:nmcmc){
###### lambda
for(k in 1:dp){
lambda.cond<-NULL
lambda.cond<-lambda
tg<-mcmc.ma.lambda[1:(i-1), k]
temlambda<-0.95*rnorm(1, mean=lambda[k], sd=2.38*sd(tg))+
  0.05*rnorm(1, mean=lambda[k], sd=0.1)
lambda.cond[k]<-temlambda
com.phi<-log.post1(d=ff$d, odut=ff$odut,dup=ff$dup, y,lambda.cond, cp)$logpost-
  log.post1(d=ff$d, odut=ff$odut,dup=ff$dup,y,lambda, cp)$logpost
u<-runif(1)
if(log(u)<com.phi){
lambda[k]<-lambda.cond[k]
accept.lambda[1,k]=accept.lambda[1,k]+1
}
reasonable.lambda[1, k]=reasonable.lambda[1,k]+1
}
mcmc.ma.lambda[i,]<-lambda
if(i>burn&&((i-burn)%%thin==0)){
j=j+1
fit10<-pred1(ff$d,ff$odut,ff$dup,cov.dd$dis, y,lambda, cp)
res[j,]=fit10$res
v.term2[j,]=fit10$v.term2
}
if ((i%%(0.1*nmcmc))==0){
print(c(i/nmcmc))
}
}
m<-list(reasonable.lambda=reasonable.lambda, accept.lambda=accept.lambda, 
        mcmc.ma.lambda=mcmc.ma.lambda, res=res, v.term2=v.term2)
return(m)
}


###run MCMC
runBMCMC<-function(nmcmc,burn,thin,x,y,xtest1, lambda.ini, lambda.w.ini, cp){
nmcmc=nmcmc
burn<-burn
thin=thin
x=x;xtest1=xtest1;y=y
lambda.w.ini<-lambda.w.ini
xxy<-bceMCMC(nmcmc,burn,thin,x,y,xtest1, lambda.ini, lambda.w.ini, cp)
var.term1<-apply(xxy$res,2,var)
var.term2<-apply(xxy$v.term2,2,mean)
pred.var<-var.term1+var.term2  
pred.y<-apply(xxy$res,2,mean)
m<-list(pred.y=pred.y, pred.var=pred.var, reasonable.lambda=xxy$reasonable.lambda, accept.lambda=xxy$accept.lambda, 
        mcmc.ma.lambda=xxy$mcmc.ma.lambda)
return(m)
}


